#include <iostream>
#include <vector>
#include <algorithm>
#include <numeric>

using namespace std;

// Function to find the highest round the favorite friend can reach
int findHighestRound(int N, vector<int>& strengths, int Mi, int Ji) {
    vector<int> friends(N);  // Create a vector to store friends' strengths
    iota(friends.begin(), friends.end(), 1);  // Fill vector with values from 1 to N

    // Swap two friends Ji times (excluding Mi)
    for (int j = 0; j < Ji; ++j) {
        if (friends[j] != Mi && friends[j + 1] != Mi) {
            swap(strengths[friends[j] - 1], strengths[friends[j + 1] - 1]);
        }
    }

    // Simulate the tournament rounds
    int round = 1;
    while (N > 1) {
        vector<int> winners;
        for (int i = 0; i < N; i += 2) {
            if (strengths[i] > strengths[i + 1]) {
                winners.push_back(friends[i]);
            } else {
                winners.push_back(friends[i + 1]);
            }
        }
        friends = winners;  // Update friends for the next round
        N /= 2;  // Reduce the number of friends for the next round
        ++round;
    }

    return round;
}

int main() {
    // Input
    int N;
    cin >> N;

    vector<int> strengths(N);
    for (int i = 0; i < N; ++i) {
        cin >> strengths[i];
    }

    int Q;
    cin >> Q;

    // Output
    vector<int> results;
    for (int i = 0; i < Q; ++i) {
        int Mi, Ji;
        cin >> Mi >> Ji;

        // Find and store the highest round for the favorite friend
        results.push_back(findHighestRound(N, strengths, Mi, Ji));
    }

    // Print the results after reading all inputs
    for (int result : results) {
        cout << result << endl;
    }

    return 0;
}